//+------------------------------------------------------------------+ 
//| HMA.mq4 
//| Copyright  2006 WizardSerg <wizardserg@mail.ru>, ?? ??????? ForexMagazine #104 
//| wizardserg@mail.ru 
//|                         Revised by IgorAD,igorad2003@yahoo.co.uk |   
//|                                        http://www.forex-tsd.com/ |                                      
//+------------------------------------------------------------------+
#property copyright "MT4 release WizardSerg <wizardserg@mail.ru>, ?? ??????? ForexMagazine #104" 
#property link      "wizardserg@mail.ru" 

#property indicator_chart_window 
#property indicator_buffers 2 
#property indicator_color1 Green 
#property indicator_color2 DarkViolet 
//---- input parameters 
extern int       period=21; 
extern int       method=3;                         // MODE_SMA 
extern int       price=0;                          // PRICE_CLOSE 
extern bool      Alert_Enabled=true;
extern bool      Email_Enabled=true;
extern string    Email_Subject="HMA Color Change";
//---- buffers 
double Uptrend[];
double Dntrend[];
double ExtMapBuffer[]; 
bool Uptrend_Alert_Signal;
bool Downtrend_Alert_Signal;
bool Uptrend_Email_Signal;
bool Downtrend_Email_Signal;

//+------------------------------------------------------------------+ 
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int init() 
{ 
    IndicatorBuffers(3);  
    SetIndexBuffer(0, Uptrend); 
    //ArraySetAsSeries(Uptrend, true); 
    SetIndexBuffer(1, Dntrend); 
    //ArraySetAsSeries(Dntrend, true); 
    SetIndexBuffer(2, ExtMapBuffer); 
    ArraySetAsSeries(ExtMapBuffer, true); 
    
    SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,2);
    SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,2);
    
    IndicatorShortName("Hull Moving Average("+period+")"); 
    Uptrend_Alert_Signal = false;
    Downtrend_Alert_Signal = false;
    Uptrend_Email_Signal = false;
    Downtrend_Email_Signal = false;
   
    return(0); 
} 

//+------------------------------------------------------------------+ 
//| Custor indicator deinitialization function                       | 
//+------------------------------------------------------------------+ 
int deinit() 
{ 
    // ???? ????? ?????? ?????? 
    return(0); 
} 

//+------------------------------------------------------------------+ 
//| ?????????? ???????                                               | 
//+------------------------------------------------------------------+ 
double WMA(int x, int p) 
{ 
    return(iMA(NULL, 0, p, 0, method, price, x));    
} 

//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int start() 
{ 
    int counted_bars = IndicatorCounted(); 
    
    if(counted_bars < 0) 
        return(-1); 
                  
    int x = 0; 
    int p = MathSqrt(period);              
    int e = Bars - counted_bars + period + 1; 
    
    double vect[], trend[]; 
    
    if(e > Bars) 
        e = Bars;    

    ArrayResize(vect, e); 
    ArraySetAsSeries(vect, true);
    ArrayResize(trend, e); 
    ArraySetAsSeries(trend, true); 
    
    for(x = 0; x < e; x++) 
    { 
        vect[x] = 2*WMA(x, period/2) - WMA(x, period);        
 //       Print("Bar date/time: ", TimeToStr(Time[x]), " close: ", Close[x], " vect[", x, "] = ", vect[x], " 2*WMA(p/2) = ", 2*WMA(x, period/2), " WMA(p) = ",  WMA(x, period)); 
    } 

    for(x = 0; x < e-period; x++)
     
        ExtMapBuffer[x] = iMAOnArray(vect, 0, p, 0, method, x);        
    
    for(x = e-period; x >= 0; x--)
    {     
        trend[x] = trend[x+1];
        if (ExtMapBuffer[x]> ExtMapBuffer[x+1]) trend[x] =1;
        if (ExtMapBuffer[x]< ExtMapBuffer[x+1]) trend[x] =-1;
    
    if (trend[x]>0)
    { Uptrend[x] = ExtMapBuffer[x]; 
      if (trend[x+1]<0) Uptrend[x+1]=ExtMapBuffer[x+1];
      Dntrend[x] = EMPTY_VALUE;
      if(x==0 && Dntrend[x] == EMPTY_VALUE && Dntrend[x+1] != EMPTY_VALUE && Alert_Enabled == true && Uptrend_Alert_Signal == false)
      {
      Alert("HMA Color Change on " + Symbol());
      Uptrend_Alert_Signal = true;
      Downtrend_Alert_Signal = false;
      }
      if(x==0 && Dntrend[x] == EMPTY_VALUE && Dntrend[x+1] != EMPTY_VALUE && Email_Enabled == true && Uptrend_Email_Signal == false)
      {
      SendMail(Email_Subject, "HMA Color Change on " + Symbol());
      Uptrend_Email_Signal = true;
      Downtrend_Email_Signal = false;
      }
      
    }
    else              
    if (trend[x]<0)
    { 
      Dntrend[x] = ExtMapBuffer[x]; 
      if (trend[x+1]>0) Dntrend[x+1]=ExtMapBuffer[x+1];
      Uptrend[x] = EMPTY_VALUE;
      if(x==0 && Uptrend[x] == EMPTY_VALUE && Uptrend[x+1] != EMPTY_VALUE && Alert_Enabled == true && Downtrend_Alert_Signal == false)
      {
      Alert("HMA Color Change on " + Symbol());
      Uptrend_Alert_Signal = false;
      Downtrend_Alert_Signal = true;
      }
      if(x==0 && Uptrend[x] == EMPTY_VALUE && Uptrend[x+1] != EMPTY_VALUE && Email_Enabled == true && Downtrend_Email_Signal == false)
      {
      SendMail(Email_Subject, "HMA Color Change on " + Symbol());
      Uptrend_Email_Signal = false;
      Downtrend_Email_Signal = true;
      }
    }              
    
   // Print( " trend=",trend[x]);
    }
    
    return(0); 
} 
//+------------------------------------------------------------------+ 